
#ifndef __STRUCT_VARAN_CLIENT_APP_EXT_DIAG_T__
#define __STRUCT_VARAN_CLIENT_APP_EXT_DIAG_T__
typedef struct VARAN_CLIENT_APP_EXT_DIAG_Ttag {

  unsigned long ulRcxSetCfgReq;      /* Number of receiced set configuration requests */
  unsigned long ulRcxSetCfgPosCnf;  /* Number of successful set configuration requests */
  unsigned long ulRcxSetCfgNegCnf;  /* Number of successful set configuration requests */

  unsigned long ulRcxChnlInitReq;    /* Number of channel init requests */
  unsigned long ulRcxChnlInitPosCnf; /* Number of successful channel init requests */
  unsigned long ulRcxChnlInitNegCnf; /* Number of unsuccessful channel init requests */

  unsigned long ulRcxStartStopReq;      /* Number of start/stop communication requests */

  unsigned long ulRcxRegAppReq;     /* Number of register application request */
  unsigned long ulRcxRegAppPosCnf;  /* Number of successful register application request */
  unsigned long ulRcxRegAppNegCnf;  /* Number of unsuccessful register application request */

  unsigned long ulRcxSetWDTimeReq;  /* Number of set host watchdog time requests */
  unsigned long ulRcxSetWDTimePosCnf;  /* Number of successful set host watchdog time requests */
  unsigned long ulRcxSetWDTimeNegCnf;  /* Number of unsuccessful set host watchdog time requests */

  unsigned long ulRcxGetDiagReq;    /* Number of get diagnosis request */
  unsigned long ulRcxWDInd;          /* Number of host watchdog time expirations */
  unsigned long ulRcxLockUnlockReq; /* Number of lock/unlock request */
  unsigned long ulRcxGetWDTimeReq;  /* Number of get host watchdog time requests */
  unsigned long ulRcxUnregAppReq;    /* Number of unregister application request */
  unsigned long ulRcxGetDPMIOSizeReq;/* Number of get DPM IO size requests */
  unsigned long ulRcxDelCfgReq;       /* Number of delete configuration requests */

  unsigned long ulChaneOfStateInd;     /* Number of receiced set configuration requests */
}VARAN_CLIENT_APP_EXT_DIAG_T;
#endif

#ifndef __STRUCT_VARAN_CLIENT_EXT_CONF_DIAG_T__
#define __STRUCT_VARAN_CLIENT_EXT_CONF_DIAG_T__

typedef __PACKED_PRE struct __PACKED_POST VARAN_CLIENT_EXT_CONFIG_DIAG_Ttag{
  /** Application Interface Initialization  */
  unsigned long  ulSystemFlags;           /* System flags          */
  unsigned long  ulWdgTime;               /* App. Watchdog timeout */
  unsigned long  ulAppMode;               /* App. Mode             */
  unsigned char  abReserved0[20];          /* App. Param Reserved   */

  /** Device Identity configuration */
  unsigned long  ulVendorId;              /* VendorID              */
  unsigned long  ulDeviceId;              /* DeviceID              */
  unsigned long  ulLicenseNumber;         /* LicNumber             */
  unsigned long  ulProductRevision;       /* Revision              */
  unsigned char  abVendorName[64];        /* Vendor Name           */
  unsigned char  abDeviceName[64];        /* Device Name           */
  unsigned long  ulSerialNumber;          /* Serial Number         */
  unsigned long  ulOrderNumber;           /* Order Number          */
  unsigned char  abReserved1[8];         /* Resreved              */

  /**Protocol Process Data configuration */
  unsigned long  ulMemArea1ReadOffset;    /* MemArea1 Read  Offset */
  unsigned long  ulMemArea1ReadSize;      /* MemArea1 Read  Size   */
  unsigned long  ulMemArea1WriteOffset;   /* MemArea1 Write Offset */
  unsigned long  ulMemArea1WriteSize;     /* MemArea1 Write Size   */

  unsigned long  ulMemArea2ReadOffset;    /* MemArea2 Read  Offset */
  unsigned long  ulMemArea2ReadSize;      /* MemArea2 Read  Size   */
  unsigned long  ulMemArea2WriteOffset;   /* MemArea2 Write Offset */
  unsigned long  ulMemArea2WriteSize;     /* MemArea2 Write Size   */

  /** Protocol Misc configuration */
  unsigned long  ulConfigFlags;           /* Configuration flags   */
  unsigned long  ulClientWdgTime;         /* Client watchdog time  */
  unsigned char  abReserved2[32] ;        /* Reserved              */

  /** Protocol SYNC configuration */
  unsigned long  ulSyncOutPulsLen;        /* SYNC OUT puls length  */
  unsigned long  ulSyncOut0Mode;          /* SYNC OUT 0 ID         */
  unsigned long  ulSyncOut0Flags;         /* SYNC OUT 0 Flags      */
  unsigned long  ulSyncOut1Mode;          /* SYNC OUT 1 ID         */
  unsigned long  ulSyncOut1Flags;         /* SYNC OUT 1 Flags      */

  /** Protocol EMAC configuration */
  unsigned char  abReserved3[16] ;     /* Reserved for EMAC cfg  */

}VARAN_CLIENT_EXT_CONFIG_DIAG_T;

#endif

